/*
  Third person ball launcher attachment for Bombing Run.
  
  Author Mark Caldwell aka W@rHe@d of The Reliquary
*/
class UTBRBallLauncherAttachment extends UTBRWeaponAttachment;

var DynamicLightEnvironmentComponent Lights[2];

simulated function AttachTo(UTPawn OwnerPawn)
{
    super.AttachTo(OwnerPawn);
    
    if ((OwnerPawn != none) && (ValidTeamNum(OwnerPawn.GetTeamNum())))
    {
        //since the attachment is a component added to the ownerpawn,
        //need to add the light to the ownerpawn component list or it will
        //not be viewable
        OwnerPawn.AttachComponent(Lights[OwnerPawn.GetTeamNum()]);
    }
}

simulated function DetachFrom( SkeletalMeshComponent MeshCpnt )
{
    super.DetachFrom(MeshCpnt);
    
    if ((Instigator != none) && (ValidTeamNum(Instigator.GetTeamNum())))
    {
        DetachComponent(Lights[Instigator.GetTeamNum()]);
    }
}

simulated function bool ValidTeamNum(int num)
{
    return (num ==0) || (num ==1 );
}

simulated function SetSkin(Material NewMaterial)
{ 
    if ((Instigator != none) && (ValidTeamNum(Instigator.GetTeamNum())))
    {
        StaticMesh.SetLightEnvironment(Lights[Instigator.GetTeamNum()]);
    }
       
    if (bool(UTBRGame(WorldInfo.Game).Settings.NecrisTheme))
    {
        StaticMesh.SetMaterial(0, Material'UN_Liquid.SM.Materials.M_UN_Liquid_SM_NanoBlack_03_Master');
    }
    else
    {
        StaticMesh.SetMaterial(0, Material'LT_Deco.SM.Materials.M_LT_Deco_SM_Holodisplay01_B');   
    }
}

        
defaultproperties
{
   DrawScale=1.4

   Begin Object Class=DynamicLightEnvironmentComponent Name=Light0 ObjName=Light0 Archetype=DynamicLightEnvironmentComponent'Engine.Default__DynamicLightEnvironmentComponent'
      bDynamic=True
      bCastShadows=False        
      AmbientGlow=(R=5.000000,G=0.000000,B=0.000000,A=1.000000)
      Name="Light0"
      ObjectArchetype=DynamicLightEnvironmentComponent'Engine.Default__DynamicLightEnvironmentComponent'
   End Object
   Lights(0)=Light0
   
   Begin Object Class=DynamicLightEnvironmentComponent Name=Light1 ObjName=Light1 Archetype=DynamicLightEnvironmentComponent'Engine.Default__DynamicLightEnvironmentComponent'
      bDynamic=True
      bCastShadows=False        
      AmbientGlow=(R=0.000000,G=0.000000,B=5.000000,A=1.000000)
      Name="Light1"
      ObjectArchetype=DynamicLightEnvironmentComponent'Engine.Default__DynamicLightEnvironmentComponent'
   End Object      
   Lights(1)=Light1   
       
   Begin Object Class=StaticMeshComponent Name=BLMesh3 ObjName=BLMesh3 Archetype=StaticMeshComponent'Engine.Default__StaticMeshComponent'
      StaticMesh=StaticMesh'WP_FlakCannon.Mesh.S_WP_Flak_3P' 
      bUseAsOccluder=False
      CastShadow=False
      Name="BLMesh3"
      ObjectArchetype=StaticMeshComponent'Engine.Default__StaticMeshComponent'  
      Translation=(X=0.000000,Y=20.000000,Z=0)
      BlockActors=true
   End Object
   StaticMesh=BLMesh3 

   WeaponClass=Class'BombingRun.UTBRBallLauncher'
   FireAnim="WeaponFire"
   Name="Default__UTBRBallLauncherAttachment"
   ObjectArchetype=UTWeaponAttachment'UTGame.Default__UTWeaponAttachment'
       
   //Components(0)=BLMesh3
   Components(0)=Light0
   Components(1)=Light1
}